<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Заполнение анкеты';
$this->params['breadcrumbs'][] = $this->title;

// Определяем текущий шаг
$step = Yii::$app->request->get('step', 1);
$nextStep = $step + 1;
$prevStep = $step - 1;

$this->registerCss("
.anketa-container {
    max-width: 900px;
    margin: 0 auto;
}

.section {
    background: white;
    border-radius: 10px;
    padding: 30px;
    margin-bottom: 30px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
}

.section-title {
    color: #3949ab;
    margin-bottom: 25px;
    padding-bottom: 15px;
    border-bottom: 2px solid #e8eaf6;
    font-size: 1.5rem;
}

.form-row {
    display: flex;
    flex-wrap: wrap;
    margin: 0 -10px;
}

.form-group {
    padding: 0 10px;
    margin-bottom: 20px;
    flex: 1 0 300px;
}

.form-label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #444;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    border: 2px solid #ddd;
    border-radius: 6px;
    font-size: 16px;
    transition: all 0.3s ease;
}

.form-control:focus {
    border-color: #3949ab;
    box-shadow: 0 0 0 3px rgba(57, 73, 171, 0.1);
    outline: none;
}

.error-message {
    color: #e53935;
    font-size: 14px;
    margin-top: 5px;
    display: block;
}

.btn {
    display: inline-block;
    padding: 12px 30px;
    border: none;
    border-radius: 6px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    text-align: center;
    text-decoration: none;
}

.btn-primary {
    background: linear-gradient(45deg, #3949ab, #5c6bc0);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(57, 73, 171, 0.3);
}

.btn-secondary {
    background: #78909c;
    color: white;
}

.btn-secondary:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(120, 144, 156, 0.3);
}

.step-indicator {
    display: flex;
    justify-content: space-between;
    margin-bottom: 30px;
    position: relative;
}

.step {
    display: flex;
    flex-direction: column;
    align-items: center;
    flex: 1;
    position: relative;
    z-index: 1;
}

.step-number {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #e0e0e0;
    color: #666;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    margin-bottom: 10px;
    transition: all 0.3s ease;
}

.step.active .step-number {
    background: #3949ab;
    color: white;
    transform: scale(1.1);
}

.step-label {
    font-size: 14px;
    color: #666;
    text-align: center;
}

.step-connector {
    position: absolute;
    top: 20px;
    left: 0;
    right: 0;
    height: 2px;
    background: #e0e0e0;
    z-index: 0;
}

.progress-bar {
    width: 100%;
    height: 8px;
    background: #e0e0e0;
    border-radius: 4px;
    margin-bottom: 30px;
    overflow: hidden;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #4caf50, #66bb6a);
    width: " . ($step / 4 * 100) . "%;
    transition: width 0.5s ease;
}

.file-info {
    font-size: 12px;
    color: #666;
    margin-top: 5px;
    margin-bottom: 10px;
}

.form-navigation {
    display: flex;
    justify-content: space-between;
    margin-top: 40px;
    padding-top: 20px;
    border-top: 1px solid #eee;
}
");

// Проверяем, была ли отправлена форма
if ($model->load(Yii::$app->request->post())) {
    // Сохраняем данные в сессии для многошаговой формы
    $session = Yii::$app->session;
    $formData = $session->get('formData', []);
    $formData = array_merge($formData, Yii::$app->request->post('EmployeeProfile', []));
    $session->set('formData', $formData);
    
    // Если это последний шаг, сохраняем данные
    if ($step == 4) {
        $model->attributes = $formData;
        $model->user_id = Yii::$app->user->id;
        
        // Загрузка файлов
        $model->photoFile = \yii\web\UploadedFile::getInstance($model, 'photoFile');
        $model->passportScanFile = \yii\web\UploadedFile::getInstance($model, 'passportScanFile');
        $model->diplomaScanFile = \yii\web\UploadedFile::getInstance($model, 'diplomaScanFile');
        $model->snilsScanFile = \yii\web\UploadedFile::getInstance($model, 'snilsScanFile');
        
        if ($model->save()) {
            if ($model->upload()) {
                Yii::$app->session->setFlash('success', '✅ Анкета успешно создана и отправлена на проверку!');
                $session->remove('formData'); // Очищаем сессию
                return $this->redirect(['profile/index']);
            } else {
                Yii::$app->session->setFlash('warning', 'Анкета сохранена, но возникли проблемы с загрузкой файлов.');
            }
        } else {
            Yii::$app->session->setFlash('error', 'Ошибка при сохранении анкеты. Проверьте введенные данные.');
        }
    }
    
    // Переходим к следующему шагу
    if ($step < 4) {
        return $this->redirect(['create', 'step' => $nextStep]);
    }
}

// Загружаем сохраненные данные из сессии для текущего шага
$session = Yii::$app->session;
if ($session->has('formData')) {
    $formData = $session->get('formData');
    $model->attributes = $formData;
}
?>

<div class="anketa-container">
    <h1 class="text-center" style="margin-bottom: 40px; color: #3949ab;">
        <span style="font-size: 2.5rem;">📋</span><br>
        Анкета сотрудника
    </h1>
    
    <div class="progress-bar">
        <div class="progress-fill"></div>
    </div>
    
    <div class="step-indicator">
        <div class="step <?= $step >= 1 ? 'active' : '' ?>">
            <div class="step-number">1</div>
            <div class="step-label">Личные данные</div>
        </div>
        <div class="step <?= $step >= 2 ? 'active' : '' ?>">
            <div class="step-number">2</div>
            <div class="step-label">Паспортные данные</div>
        </div>
        <div class="step <?= $step >= 3 ? 'active' : '' ?>">
            <div class="step-number">3</div>
            <div class="step-label">Образование</div>
        </div>
        <div class="step <?= $step >= 4 ? 'active' : '' ?>">
            <div class="step-number">4</div>
            <div class="step-label">Работа и прочее</div>
        </div>
        <div class="step-connector"></div>
    </div>

    <?php $form = ActiveForm::begin([
        'id' => 'anketa-form',
        'options' => ['enctype' => 'multipart/form-data', 'class' => 'form'],
        'fieldConfig' => [
            'template' => "{label}\n{input}\n{error}",
            'labelOptions' => ['class' => 'form-label'],
            'inputOptions' => ['class' => 'form-control'],
            'errorOptions' => ['class' => 'error-message'],
        ],
    ]); ?>

    <!-- Скрытое поле для хранения текущего шага -->
    <input type="hidden" name="step" value="<?= $step ?>">

    <?php if ($step == 1): ?>
        <!-- Шаг 1: Личные данные -->
        <div class="section">
            <h2 class="section-title">
                <span>👤</span> Личные данные
            </h2>
            
            <div class="form-row">
                <div class="form-group">
                    <?= $form->field($model, 'full_name')->textInput([
                        'value' => $user->full_name,
                        'readonly' => true,
                        'style' => 'background: #f5f5f5;'
                    ]) ?>
                </div>
                
                <div class="form-group">
                    <?= $form->field($model, 'birth_date')->textInput([
                        'type' => 'date',
                        'max' => date('Y-m-d', strtotime('-18 years'))
                    ]) ?>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <?= $form->field($model, 'gender')->dropDownList($model->getGenderList(), [
                        'prompt' => '-- Выберите пол --'
                    ]) ?>
                </div>
                
                <div class="form-group">
                    <?= $form->field($model, 'citizenship')->textInput([
                        'placeholder' => 'Российская Федерация'
                    ]) ?>
                </div>
            </div>
            
            <div class="form-group">
                <label class="form-label">Фото сотрудника (необязательно)</label>
                <div class="file-info">
                    Форматы: JPG, PNG, PDF | Макс. размер: 10MB
                </div>
                <?= $form->field($model, 'photoFile')->fileInput()->label(false) ?>
            </div>
        </div>

    <?php elseif ($step == 2): ?>
        <!-- Шаг 2: Паспортные данные -->
        <div class="section">
            <h2 class="section-title">
                <span>🛂</span> Паспортные данные
            </h2>
            
            <div class="form-row">
                <div class="form-group">
                    <?= $form->field($model, 'passport_series')->textInput([
                        'placeholder' => '0000'
                    ]) ?>
                </div>
                
                <div class="form-group">
                    <?= $form->field($model, 'passport_number')->textInput([
                        'placeholder' => '000000'
                    ]) ?>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <?= $form->field($model, 'passport_issued_by')->textInput([
                        'placeholder' => 'ОУФМС России по...'
                    ]) ?>
                </div>
                
                <div class="form-group">
                    <?= $form->field($model, 'passport_issue_date')->textInput([
                        'type' => 'date'
                    ]) ?>
                </div>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'passport_registration')->textarea([
                    'rows' => 3,
                    'placeholder' => 'Адрес регистрации по месту жительства...'
                ]) ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'marital_status')->dropDownList($model->getMaritalStatusList(), [
                    'prompt' => '-- Выберите семейное положение --'
                ]) ?>
            </div>
            
            <div class="form-group">
                <label class="form-label">Скан паспорта (необязательно)</label>
                <div class="file-info">
                    Форматы: JPG, PNG, PDF | Макс. размер: 20MB
                </div>
                <?= $form->field($model, 'passportScanFile')->fileInput()->label(false) ?>
            </div>
        </div>

    <?php elseif ($step == 3): ?>
        <!-- Шаг 3: Образование -->
        <div class="section">
            <h2 class="section-title">
                <span>🎓</span> Образование
            </h2>
            
            <div class="form-group">
                <?= $form->field($model, 'education')->dropDownList($model->getEducationList(), [
                    'prompt' => '-- Выберите уровень образования --'
                ]) ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'education_organization')->textInput([
                    'placeholder' => 'Например: МГУ им. Ломоносова'
                ]) ?>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <?= $form->field($model, 'specialty')->textInput([
                        'placeholder' => 'Например: Программная инженерия'
                    ]) ?>
                </div>
                
                <div class="form-group">
                    <?= $form->field($model, 'qualification')->textInput([
                        'placeholder' => 'Например: Бакалавр'
                    ]) ?>
                </div>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'diploma_number')->textInput([
                    'placeholder' => 'Номер диплома'
                ]) ?>
            </div>
            
            <div class="form-group">
                <label class="form-label">Скан диплома (необязательно)</label>
                <div class="file-info">
                    Форматы: JPG, PNG, PDF | Макс. размер: 20MB
                </div>
                <?= $form->field($model, 'diplomaScanFile')->fileInput()->label(false) ?>
            </div>
        </div>

    <?php elseif ($step == 4): ?>
        <!-- Шаг 4: Работа и прочее -->
        <div class="section">
            <h2 class="section-title">
                <span>💼</span> Работа и дополнительная информация
            </h2>
            
            <div class="form-row">
                <div class="form-group">
                    <?= $form->field($model, 'workplace')->textInput([
                        'placeholder' => 'Название организации'
                    ]) ?>
                </div>
                
                <div class="form-group">
                    <?= $form->field($model, 'position')->textInput([
                        'placeholder' => 'Должность'
                    ]) ?>
                </div>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'experience')->textInput([
                    'type' => 'number',
                    'min' => 0,
                    'placeholder' => 'Стаж в месяцах'
                ]) ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'snils')->textInput([
                    'placeholder' => '000-000-000 00'
                ]) ?>
            </div>
            
            <div class="form-group">
                <label class="form-label">Скан СНИЛС (необязательно)</label>
                <div class="file-info">
                    Форматы: JPG, PNG, PDF | Макс. размер: 10MB
                </div>
                <?= $form->field($model, 'snilsScanFile')->fileInput()->label(false) ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'health_status')->textarea([
                    'rows' => 3,
                    'placeholder' => 'Опишите состояние здоровья, хронические заболевания, аллергии и т.д.'
                ]) ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'additional_info')->textarea([
                    'rows' => 4,
                    'placeholder' => 'Дополнительная информация, которую считаете нужной указать...'
                ]) ?>
            </div>
        </div>
    <?php endif; ?>

    <div class="form-navigation">
        <?php if ($step > 1): ?>
            <a href="<?= \yii\helpers\Url::to(['create', 'step' => $prevStep]) ?>" 
               class="btn btn-secondary">
                ← Назад
            </a>
        <?php else: ?>
            <div></div> <!-- Пустой div для выравнивания -->
        <?php endif; ?>

        <?php if ($step < 4): ?>
            <button type="submit" class="btn btn-primary">
                Далее →
            </button>
        <?php else: ?>
            <button type="submit" class="btn btn-primary" style="background: linear-gradient(45deg, #4caf50, #66bb6a);">
                Отправить анкету на проверку
            </button>
        <?php endif; ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>

<div style="text-align: center; margin-top: 30px; color: #666; font-size: 14px;">
    <p>Шаг <?= $step ?> из 4</p>
    <?php if ($step == 4): ?>
        <p style="color: #4caf50; font-weight: bold;">Проверьте все данные перед отправкой!</p>
    <?php endif; ?>
</div>