<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

$this->title = 'Просмотр анкеты';
$this->params['breadcrumbs'][] = ['label' => 'Панель администратора', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$this->registerCss("
.admin-view {
    max-width: 1000px;
    margin: 0 auto;
}

.profile-header {
    background: linear-gradient(135deg, #3949ab 0%, #5c6bc0 100%);
    color: white;
    border-radius: 15px;
    padding: 40px;
    margin-bottom: 40px;
    box-shadow: 0 10px 30px rgba(57, 73, 171, 0.3);
}

.profile-photo {
    width: 150px;
    height: 150px;
    border-radius: 50%;
    object-fit: cover;
    border: 5px solid white;
    margin-bottom: 20px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}

.section {
    background: white;
    border-radius: 10px;
    padding: 30px;
    margin-bottom: 30px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
}

.section-title {
    color: #3949ab;
    margin-bottom: 25px;
    padding-bottom: 15px;
    border-bottom: 2px solid #e8eaf6;
    font-size: 1.5rem;
}

.info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 20px;
}

.info-item {
    margin-bottom: 15px;
}

.info-label {
    font-size: 14px;
    color: #666;
    margin-bottom: 5px;
    font-weight: 500;
}

.info-value {
    font-size: 16px;
    color: #333;
    font-weight: 400;
}

.status-section {
    background: #f8f9fa;
    border-left: 4px solid #3949ab;
    padding: 20px;
    border-radius: 8px;
    margin-bottom: 30px;
}

.status-form {
    margin-top: 20px;
}

.action-buttons {
    display: flex;
    gap: 15px;
    flex-wrap: wrap;
    margin-top: 30px;
}

.file-link {
    display: inline-flex;
    align-items: center;
    color: #3949ab;
    text-decoration: none;
    padding: 8px 15px;
    background: #f0f4ff;
    border-radius: 6px;
    transition: all 0.3s ease;
}

.file-link:hover {
    background: #e1e8ff;
    transform: translateY(-2px);
}
");
?>

<div class="admin-view">
    <div class="profile-header">
        <?php if ($model->photo): ?>
            <img src="<?= Url::to(['/uploads/' . $model->photo]) ?>" 
                 class="profile-photo" 
                 alt="Фото сотрудника">
        <?php else: ?>
            <div style="width: 150px; height: 150px; border-radius: 50%; background: rgba(255,255,255,0.2); 
                        display: flex; align-items: center; justify-content: center; margin: 0 auto 20px;">
                <span style="font-size: 3rem;">👤</span>
            </div>
        <?php endif; ?>
        
        <h1><?= Html::encode($model->user->full_name) ?></h1>
        <p>Анкета сотрудника #<?= $model->id ?></p>
        
        <?php 
        $statusClass = '';
        switch ($model->status) {
            case 'new': $statusClass = 'status-new'; break;
            case 'in_review': $statusClass = 'status-review'; break;
            case 'accepted': $statusClass = 'status-accepted'; break;
        }
        ?>
        <div style="display: inline-block; padding: 8px 20px; border-radius: 20px; background: white; color: #3949ab; font-weight: bold; margin-top: 15px;">
            Статус: <?= $model->getStatusName() ?>
        </div>
    </div>

    <!-- Секция статуса -->
    <div class="status-section">
        <h3 class="section-title">Управление статусом</h3>
        
        <div class="action-buttons">
            <?php if ($model->status !== 'in_review'): ?>
                <?= Html::a('Взять в работу', ['update-status', 'id' => $model->id, 'status' => 'in_review'], [
                    'class' => 'btn',
                    'style' => 'background: #ff9800; color: white;',
                    'onclick' => "return confirm('Взять анкету в работу?')"
                ]) ?>
            <?php endif; ?>
            
            <?php if ($model->status !== 'accepted'): ?>
                <?= Html::a('Принять анкету', ['update-status', 'id' => $model->id, 'status' => 'accepted'], [
                    'class' => 'btn',
                    'style' => 'background: #4caf50; color: white;',
                    'onclick' => "return confirm('Принять анкету?')"
                ]) ?>
            <?php endif; ?>
            
            <?= Html::a('Назад к списку', ['index'], [
                'class' => 'btn',
                'style' => 'background: #78909c; color: white;'
            ]) ?>
        </div>
    </div>

    <!-- Личные данные -->
    <div class="section">
        <h2 class="section-title">Личные данные</h2>
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">ФИО</div>
                <div class="info-value"><?= Html::encode($model->user->full_name) ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Email</div>
                <div class="info-value"><?= Html::encode($model->user->email) ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Телефон</div>
                <div class="info-value"><?= Html::encode($model->user->phone) ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Дата рождения</div>
                <div class="info-value"><?= $model->birth_date ? Yii::$app->formatter->asDate($model->birth_date) : 'Не указана' ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Пол</div>
                <div class="info-value"><?= $model->getGenderName() ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Гражданство</div>
                <div class="info-value"><?= Html::encode($model->citizenship) ?></div>
            </div>
        </div>
    </div>

    <!-- Паспортные данные -->
    <div class="section">
        <h2 class="section-title">Паспортные данные</h2>
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">Серия и номер</div>
                <div class="info-value">
                    <?= $model->passport_series && $model->passport_number ? 
                        $model->passport_series . ' ' . $model->passport_number : 'Не указаны' ?>
                </div>
            </div>
            <div class="info-item">
                <div class="info-label">Кем выдан</div>
                <div class="info-value"><?= Html::encode($model->passport_issued_by) ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Дата выдачи</div>
                <div class="info-value"><?= $model->passport_issue_date ? Yii::$app->formatter->asDate($model->passport_issue_date) : 'Не указана' ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Адрес регистрации</div>
                <div class="info-value"><?= Html::encode($model->passport_registration) ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Семейное положение</div>
                <div class="info-value"><?= $model->getMaritalStatusName() ?></div>
            </div>
            <?php if ($model->passport_scan): ?>
            <div class="info-item">
                <div class="info-label">Скан паспорта</div>
                <div class="info-value">
                    <a href="<?= $model->getFileUrl('passport_scan') ?>" 
                       target="_blank" 
                       class="file-link">
                        📄 Просмотреть скан
                    </a>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Образование -->
    <div class="section">
        <h2 class="section-title">Образование</h2>
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">Уровень образования</div>
                <div class="info-value"><?= $model->getEducationName() ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Образовательное учреждение</div>
                <div class="info-value"><?= Html::encode($model->education_organization) ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Специальность</div>
                <div class="info-value"><?= Html::encode($model->specialty) ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Квалификация</div>
                <div class="info-value"><?= Html::encode($model->qualification) ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Номер диплома</div>
                <div class="info-value"><?= Html::encode($model->diploma_number) ?></div>
            </div>
            <?php if ($model->diploma_scan): ?>
            <div class="info-item">
                <div class="info-label">Скан диплома</div>
                <div class="info-value">
                    <a href="<?= $model->getFileUrl('diploma_scan') ?>" 
                       target="_blank" 
                       class="file-link">
                        📑 Просмотреть скан
                    </a>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Работа -->
    <div class="section">
        <h2 class="section-title">Работа</h2>
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">Место работы</div>
                <div class="info-value"><?= Html::encode($model->workplace) ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Должность</div>
                <div class="info-value"><?= Html::encode($model->position) ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Стаж работы</div>
                <div class="info-value"><?= $model->getExperienceFormatted() ?></div>
            </div>
        </div>
    </div>

    <!-- Прочая информация -->
    <div class="section">
        <h2 class="section-title">Прочая информация</h2>
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">СНИЛС</div>
                <div class="info-value"><?= Html::encode($model->snils) ?></div>
            </div>
            <?php if ($model->snils_scan): ?>
            <div class="info-item">
                <div class="info-label">Скан СНИЛС</div>
                <div class="info-value">
                    <a href="<?= $model->getFileUrl('snils_scan') ?>" 
                       target="_blank" 
                       class="file-link">
                        🆔 Просмотреть скан
                    </a>
                </div>
            </div>
            <?php endif; ?>
            <div class="info-item" style="grid-column: span 2;">
                <div class="info-label">Состояние здоровья</div>
                <div class="info-value"><?= nl2br(Html::encode($model->health_status)) ?></div>
            </div>
            <div class="info-item" style="grid-column: span 2;">
                <div class="info-label">Дополнительная информация</div>
                <div class="info-value"><?= nl2br(Html::encode($model->additional_info)) ?></div>
            </div>
        </div>
    </div>

    <!-- Комментарий администратора -->
    <?php if ($model->review_comment): ?>
    <div class="section" style="background: #fff8e1;">
        <h2 class="section-title">Комментарий администратора</h2>
        <div style="padding: 20px; background: #fff3cd; border-radius: 8px; color: #856404;">
            <?= nl2br(Html::encode($model->review_comment)) ?>
        </div>
        
        <?php if ($model->reviewed_at): ?>
        <div style="margin-top: 15px; color: #666; font-size: 14px;">
            Проверено: <?= Yii::$app->formatter->asDatetime($model->reviewed_at) ?>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>

    <div class="action-buttons">
        <?= Html::a('← Назад к списку', ['index'], [
            'class' => 'btn',
            'style' => 'background: #78909c; color: white; padding: 12px 30px;'
        ]) ?>
        
        <?= Html::a('📄 Распечатать', '#', [
            'class' => 'btn',
            'style' => 'background: #2196f3; color: white; padding: 12px 30px;',
            'onclick' => 'window.print(); return false;'
        ]) ?>
    </div>
</div>