<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%profile_session}}`.
 */
class m260206_162830_create_profile_session_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%session}}', [
            'id' => $this->char(40)->notNull(),
            'expire' => $this->integer(),
            'data' => $this->binary(),
            'user_id' => $this->integer(),
            'ip_address' => $this->string(45),
            'user_agent' => $this->text(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->addPrimaryKey('pk-session', '{{%session}}', 'id');
        $this->createIndex('idx-session-user_id', '{{%session}}', 'user_id');
        $this->createIndex('idx-session-expire', '{{%session}}', 'expire');
    }


    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%profile_session}}');
    }
}
